/*
 * Decompiled with CFR 0.152.
 */
package jclass.cell.renderers;

import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import jclass.cell.CellInfo;
import jclass.cell.CellRenderer;
import jclass.util.JCImageCreator;

public class CheckboxCellRenderer
implements CellRenderer {
    private static JCImageCreator creator = null;
    private static Image boximage = null;
    private static Image checkimage = null;
    private static final String[] box_pixels = new String[]{"ggggggggggggl", "gbbbbbbbbbbl.", "gb.........l.", "gb.........l.", "gb.........l.", "gb.........l.", "gb.........l.", "gb.........l.", "gb.........l.", "gb.........l.", "gb.........l.", "gbllllllllll.", "l............"};
    private static final String[] check_pixels = new String[]{".........", ".......b.", "......bb.", ".b...bbb.", ".bb.bbb..", ".bbbbb...", "..bbb....", "...b.....", "........."};
    private static Checkbox comp = new Checkbox();

    public CheckboxCellRenderer() {
        if (creator == null) {
            creator = new JCImageCreator(comp);
            creator.setColor('g', Color.gray);
            creator.setColor('l', Color.lightGray);
            creator.setColor('b', Color.black);
            creator.setColor('.', Color.white);
            creator.setSize(box_pixels.length, box_pixels.length);
            boximage = creator.create(box_pixels);
            creator.setSize(check_pixels.length, check_pixels.length);
            checkimage = creator.create(check_pixels);
        }
    }

    public void draw(Graphics graphics, CellInfo cellInfo, Object object, boolean bl) {
        graphics.setFont(cellInfo.getFont());
        graphics.setColor(bl ? cellInfo.getSelectedForeground() : cellInfo.getForeground());
        graphics.drawImage(boximage, 1, 1, null);
        if (object == null) {
            return;
        }
        try {
            boolean bl2;
            if (object != null && (bl2 = ((Boolean)object).booleanValue())) {
                graphics.drawImage(checkimage, 3, 3, null);
                return;
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    public Dimension getPreferredSize(CellInfo cellInfo, Object object) {
        return new Dimension(box_pixels.length, box_pixels.length);
    }
}

